VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} DialogPolylineToSpline 
   Caption         =   "Convert polyline to spline"
   ClientHeight    =   10080
   ClientLeft      =   120
   ClientTop       =   468
   ClientWidth     =   4440
   OleObjectBlob   =   "DialogPolylineToSpline.frx":0000
   ShowModal       =   0   'False
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "DialogPolylineToSpline"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

' Definition globaler Variablen
  Public oLineSelection As ObjectCollection
  Public nLineSelection As Integer
  Public oLineSelectionConnectedPoints As Variant
  Public oPointSelection As ObjectCollection
  Public nPointSelection As Integer ' Anzahl der belegten Punkte
  Public mPointSelection As Integer ' maximale Anzahl der mglichen Punkte
  Public oPointSelectionCoordX As Variant
  Public oPointSelectionCoordY As Variant
  Public oPointSelectionConnectedLines As Variant
  Public oPointSelectionConnectedLinesN As Variant
  Public oPoint As Variant
  Public oPointCoordX As Variant
  Public oPointCoordY As Variant
  Public nPoint As Integer
  Public CoordinateAccuracy As Double
  Public oLineSelectionStatus As Integer ' mgliche Stati sind:
                                         ' -4 -> Fehler: Kein zusammenhngender Linienzug ausgewhlt
                                         ' -3 -> Fehler: Kein eindeutiger Linienzug ausgewhlt
                                         ' -2 -> Fehler: Keine Linien ausgewhlt
                                         ' -1 -> Fehler: Keine Elemente ausgewhlt
                                         ' +1 -> offener Linienzug
                                         ' +2 -> geschlossener Linienzug



'**********************************************
'**********************************************
'
' Mathematische Funktionen
'
'**********************************************
'**********************************************
' Inverse Sine
  Function ArcSin(X As Double) As Double
    ArcSin = Atn(X / Sqr(-X * X + 1))
    ArcSin = ArcSin * 180 / 3.1415
  End Function

' Inverse Cosine
  Function ArcCos(X As Double) As Double
    ArcCos = Atn(-X / Sqr(-X * X + 1)) + 2 * Atn(1)
    ArcCos = ArcCos * 180 / 3.1415
  End Function




'**********************************************
'**********************************************
'
' Einfgen von Zwischenpunkten
'
'**********************************************
'**********************************************
  Private Sub ButtonInsertApply_Click()
  ' Dimensionierung des aktuellen Einfge-Feldes
  ' Dabei werden die Anzahl einzufgender Punkte nach dem aktuellen
  ' Punktindex gespeichert.
    ReDim RefinePoint(nPoint) As Integer
    For i = 1 To nPoint
      RefinePoint(i) = 0
    Next i
    Dim DeltaX As Double
    Dim DeltaY As Double

    
  ' Abfrage der aktuellen Einstellungen ...
  
  ' -----------------------------------------------------
  ' Option 1: Verfeinerung nach der kleinsten Kantenlnge
  ' -----------------------------------------------------
    If OptionInsertEqualLength.Value = True _
    Then ' Option 1: Verfeinerung nach der kleinsten Kantenlnge
    ' Berechnung der minimalen Lnge
      Dim mLength As Double
      Dim iLength As Double
      DeltaX = oPointCoordX(2) - oPointCoordX(1)
      DeltaY = oPointCoordY(2) - oPointCoordY(1)
      mLength = DeltaX * DeltaX + DeltaY * DeltaY
      
    '  MsgBox "mLength = " & mLength
    ' Schleife ber alle Punkte zur Suche der minimalen Lnge
      For i = 3 To nPoint
      ' Berechnung des Winkels der Linien an den Punkten
        DeltaX = oPointCoordX(i) - oPointCoordX(i - 1)
        DeltaY = oPointCoordY(i) - oPointCoordY(i - 1)
        iLength = DeltaX * DeltaX + DeltaY * DeltaY
      ' Zhlen der einzufgenden Punkte nach dem & merken des Index
      ' MsgBox "DeltaX: " & DeltaX & " / DeltaY: " & DeltaY & " -> iLength = " & iLength
        If iLength < mLength _
        Then ' neue minimale Lnge gefunden
          mLength = iLength
        ' MsgBox "mLength = " & mLength
        End If ' neue minimale Lnge gefunden
      Next i ' Schleife ber alle Punkte zur Suche der minimalen Lnge
      
    '  MsgBox "mLength = " & mLength
      
    ' Schleife ber alle Punkte zur Suche der Berechnung der einzufgenden Punkte
      For i = 2 To nPoint
      ' Berechnung des Winkels der Linien an den Punkten
        DeltaX = oPointCoordX(i) - oPointCoordX(i - 1)
        DeltaY = oPointCoordY(i) - oPointCoordY(i - 1)
        iLength = DeltaX * DeltaX + DeltaY * DeltaY
      ' Abfrage der aktuellen Lnge
        If iLength > mLength _
        Then ' Unterteilung der Linie vor dem aktuellen Punkt
          RefinePoint(i - 1) = Int(iLength / mLength)
        End If ' Unterteilung der Linie vor dem aktuellen Punkt
      Next i ' Schleife ber alle Punkte zur Suche der Berechnung der einzufgenden Punkte
    
    End If ' Option 1: Verfeinerung nach der kleinsten Kantenlnge
  
  
  ' -----------------------------------------------------
  ' Option 2: Verfeinerung nach manueller Vorgabe
  ' -----------------------------------------------------
    If OptionInsertManual.Value = True _
    Then ' Option 2: Verfeinerung nach manueller Vorgabe
    ' Schleife ber alle Punkte zur Suche der Berechnung der einzufgenden Punkte
      For i = 1 To nPoint
          RefinePoint(i) = TextInsertManual.Value
      Next i ' Schleife ber alle Punkte zur Suche der Berechnung der einzufgenden Punkte
    
    End If ' Option 2: Verfeinerung nach manueller Vorgabe
  
  
  ' --------------------------------------------------
  ' Option 3: Verfeinerung nach den Winkeln der Kanten
  ' --------------------------------------------------
    If OptionInsertSharpEdges.Value = True _
    Then ' Option 2: Verfeinerung nach den Winkeln der Kanten
    
    ' Dimensionierung der Variablen
      Dim uX As Double
      Dim uY As Double
      Dim vX As Double
      Dim vY As Double
      Dim Alpha As Double
      Dim AlphaThreshold As Double
      Dim CosAlpha As Double
      Dim CosThresholdValue As Double
      CosThresholdValue = Cos(TextnInsertSharpEdges.Value * 3.14159 / 180)
      AlphaThreshold = TextnInsertSharpEdges.Value
    
    ' Schleife ber alle "mittleren" Punkte
      For i = 2 To nPoint - 1
      ' Aufstellen der beiden Vektoren zur Berechnung des Winkels
        uX = oPointCoordX(i - 1) - oPointCoordX(i)
        uY = oPointCoordY(i - 1) - oPointCoordY(i)
        vX = oPointCoordX(i + 1) - oPointCoordX(i)
        vY = oPointCoordY(i + 1) - oPointCoordY(i)
      ' Berechnung des aktuellen Winkels
        CosAlpha = ((uX * vX + uY * vY) / (Sqr(uX * uX + uY * uY) * Sqr(vX * vX + vY * vY)))
        Alpha = ArcCos(CosAlpha)
      ' Abfrage des Winkels und festlegen, ob der Punkt bernommen werden soll
      ' MsgBox " Punkt: " & i & " / Cos(Winkel): " & CosAlpha & "(" & CosThresholdValue & ")"
        If AlphaThreshold > Alpha _
        Then ' Einfgen eines Punktes
          RefinePoint(i - 1) = RefinePoint(i - 1) + 1
          RefinePoint(i) = RefinePoint(i) + 1
        End If ' Einfgen eines Punktes
      Next i ' Schleife ber alle "mittleren" Punkte
      
    ' berprfung des ersten Punkts, sofern es sich um einen
    ' geschlossenen Linienzug handelt
      If oLineSelectionStatus = 2 _
      Then ' geschlosssener Linienzug
      ' Aufstellen der beiden Vektoren zur Berechnung des Winkels
        i = 1
        uX = oPointCoordX(nPoint - 1) - oPointCoordX(i)
        uY = oPointCoordY(nPoint - 1) - oPointCoordY(i)
        vX = oPointCoordX(i + 1) - oPointCoordX(i)
        vY = oPointCoordY(i + 1) - oPointCoordY(i)
      ' Berechnung des aktuellen Winkels
        CosAlpha = ((uX * vX + uY * vY) / (Sqr(uX * uX + uY * uY) * Sqr(vX * vX + vY * vY)))
        Alpha = ArcCos(CosAlpha)
      ' Abfrage des Winkels und festlegen, ob der Punkt bernommen werden soll
      ' MsgBox " Punkt: " & i & " / Cos(Winkel): " & CosAlpha & "(" & CosThresholdValue & ")"
        If AlphaThreshold > Alpha _
        Then ' Lschen des Punktes
        ' Streng genommen muss hier auch der letzte Punkt elscht werden,
        ' da es sich um einen geschlossenen Linienzug handelt ...
          RefinePoint(i - 1) = RefinePoint(i - 1) + 1
          RefinePoint(i) = RefinePoint(i) + 1
        End If ' Lschen des Punktes
      
      End If ' geschlosssener Linienzug
    
    End If ' Option 2: Verfeinerung nach den Winkeln der Kanten
    
  
  ' ------------------------------------------------------
  ' Aufbau der neuen Liste anhand der einzufgenden Punkte
  ' ------------------------------------------------------
  ' Zhlen der einzufgenden Punkte
    ReDim OldPointCoordX(nPoint) As Double
    ReDim OldPointCoordY(nPoint) As Double
    nOldPoint = nPoint
    nRefinePoint = 0
    For i = 1 To nOldPoint
      nRefinePoint = nRefinePoint + RefinePoint(i)
      OldPointCoordX(i) = oPointCoordX(i)
      OldPointCoordY(i) = oPointCoordY(i)
    Next i
  '  MsgBox "nRefinePoint = " & nRefinePoint
  ' Neudimensionierung des Feldes
    ReDim oPointCoordX(nOldPoint + nRefinePoint) As Double
    ReDim oPointCoordY(nOldPoint + nRefinePoint) As Double
    
    nPoint = 0
    For i = 1 To nOldPoint - 1
    ' bernehme des aktuellen Punkts
      nPoint = nPoint + 1
      oPointCoordX(nPoint) = OldPointCoordX(i)
      oPointCoordY(nPoint) = OldPointCoordY(i)
    ' Abfrage ob Punkte eingefgt werden sollen ...
      If RefinePoint(i) > 0 _
      Then ' Einfgen der neuen Punkte
      ' Berechnung des neuen Schritt-Vektors
        DeltaX = (OldPointCoordX(i + 1) - OldPointCoordX(i)) / (RefinePoint(i) + 1)
        DeltaY = (OldPointCoordY(i + 1) - OldPointCoordY(i)) / (RefinePoint(i) + 1)
      ' Einfgen der neuen Punkte
        For j = 1 To RefinePoint(i)
         nPoint = nPoint + 1
         oPointCoordX(nPoint) = oPointCoordX(nPoint - 1) + DeltaX
         oPointCoordY(nPoint) = oPointCoordY(nPoint - 1) + DeltaY
        Next j
      End If ' Einfgen der neuen Punkte
    Next i
    nPoint = nPoint + 1
    oPointCoordX(nPoint) = OldPointCoordX(nOldPoint)
    oPointCoordY(nPoint) = OldPointCoordY(nOldPoint)
      
  End Sub
  




'**********************************************
'**********************************************
'
' VORSCHAU-GENEIERUNG BER DIE BUTTON
'
'**********************************************
'**********************************************
Private Sub ButtonReductionPreview_Click()
  Call PreviewPoints
End Sub

Private Sub ButtonSmoothenPreview_Click()
  Call PreviewPoints
End Sub

Private Sub ButtonInsertPreview_Click()
  Call PreviewPoints
End Sub



'*******************************************
'*******************************************
'
' Vorschau der aktuellen Punkte
'
'*******************************************
'*******************************************
  Private Sub PreviewPoints()
  ' Generierung der Liste der aktuellen Punkte  ' Erstellen der Punkte und Hinzufgen zur Punkteliste
    Dim oSelectSet As SelectSet
    Set oSelectSet = ThisApplication.ActiveDocument.SelectSet
    oSelectSet.Clear
    Dim oTransGeom As TransientGeometry
    Set oTransGeom = ThisApplication.TransientGeometry
    Dim oPreviewPoints As ObjectCollection
    Set oPreviewPoints = ThisApplication.TransientObjects.CreateObjectCollection
    ReDim oPoints(nPoint) As Point2d
    For i = 1 To nPoint
    ' Generieren des aktuellen Punkts
      Set oPoints(i) = oTransGeom.CreatePoint2d(oPointCoordX(i), oPointCoordY(i))
    ' Aufnahme des Punkts in die Liste
      oPreviewPoints.Add oPoints(i)
    Next i
    'oSelect.Select oPreviewPoints
  ' Hinzufgen der Punkte zur aktuellen Ebene
    Dim oSketch As PlanarSketch
    Set oSketch = ThisApplication.ActiveEditObject
    For i = 1 To nPoint
    ' Generieren des aktuellen Punkts als Mittelpunkt (mit Markierung)
      oSketch.SketchPoints.Add oPoints(i), True
    Next i
  
  ' Warten auf die Besttigung
    MsgBox "Exit preview"
  
  ' Lschen der aktuellen Punkte
    nPointPreview = oSketch.SketchPoints.Count
    For i = nPointPreview To nPointPreview - nPoint + 1 Step -1
    '  MsgBox "Typ: " & TypeName(obj)
    ' Selektieren des aktuellen Punkts
      oSelectSet.Select oSketch.SketchPoints(i)
     Next
     oSelectSet.Delete
     
  End Sub

                                       
                                         



'**********************************************
'**********************************************
'
' Selektieren der ursprnglichen Linien-Auswahl
'
'**********************************************
'**********************************************
  Sub ReselectSelection()
  
  ' Freigabe der aktuellen Auswahl
    Dim oSelectSet As SelectSet
    Set oSelectSet = ThisApplication.ActiveDocument.SelectSet
    oSelectSet.Clear
    
  ' Wieder-Auswahl der Selektion
    For Each obj In oLineSelection
      oSelectSet.Select obj
    Next
    
  End Sub
  



'************************************************
'************************************************
'
' Erneute Auswahl der derzeitigen Polylinien
'
'************************************************
'************************************************
  Private Sub ButtonPolyLineReselctSelection_Click()
  
  ' Wieder-Auswahl der Selektion
    Call ReselectSelection
  
  End Sub




'**********************************************************
'**********************************************************
'
' Zurcksetzten der aktuellen Punkte auf die letzte Auswahl
'
'**********************************************************
'**********************************************************
  Private Sub ButtonPolyLineSelectionReset_Click()
  
  ' Wieder-Auswahl der Selektion
    Call ReselectSelection
  
  ' Erneute bernahme der Selektion
    Call ButtonPolyLineSelectionApply_Click
  
  End Sub




'*********************
'*********************
'
' Reduktion der Punkte
'
'*********************
'*********************
  Private Sub ButtonReductionApply_Click()
  
  ' Liste der zu lschenden Punkte
    ReDim ReducePoint(nPoint) As Integer
    For i = 1 To nPoint
      ReducePoint(i) = 0
    Next i
    
  ' -----------------------------
  ' OPTION: Prozentuale Reduktion
  ' -----------------------------
    If OptionReductionPercent.Value = True _
    Then ' OPTION: Prozentuale Reduktion
    
    ' Berechnung der Anzahl der zu reduzierenden Punkte
      nPointReduction = Int(nPoint * 100 / TextReductionPercent.Value)
      MsgBox "Number of planned red. Points: " & nPointReduction
    ' Jeder wievielte Punkt muss gelscht werden?
      iPointReduction = Int(100 / TextReductionPercent.Value)
    ' Setzen des Endpunktes je nachdem ob der Linienzug geschlossen oder offen ist
      If oLineSelectionStatus = 2 _
      Then ' geschlosssener Linienzug
        iEnde = nPoint - 1
      Else
        iEnde = nPoint - 1
      End If ' geschlosssener Linienzug
    ' Schleife ber alle Punkte
      Dim Index As Double
      For i = 2 To iEnde
       Index = i / iPointReduction
       If Index - Int(Index) = 0 Then
        ReducePoint(i) = 1
        nPointReduction = nPointReduction + 1
       End If
      Next i
      MsgBox "Number of red. Points: " & nPointReduction
      
    End If ' OPTION: Prozentuale Reduktion
    
  ' -------------------------------------
  ' OPTION: Reduktion von groen Winkeln
  ' -------------------------------------
    If OptionReductionAngle.Value = True _
    Then ' OPTION: Reduktion von groen Winkeln
    ' WInkel-Variablen
      Dim Alpha As Double
      Dim AlphaThreshold As Double
      Dim CosAlpha As Double
      Dim CosThresholdValue As Double
      CosThresholdValue = Cos(TextReductionAngle.Value * 3.14159 / 180)
      AlphaThreshold = TextReductionAngle.Value
      
    ' Schleife ber alle "mittleren" Punkte
      For i = 2 To nPoint - 1
      ' Aufstellen der beiden Vektoren zur Berechnung des Winkels
        uX = oPointCoordX(i - 1) - oPointCoordX(i)
        uY = oPointCoordY(i - 1) - oPointCoordY(i)
        vX = oPointCoordX(i + 1) - oPointCoordX(i)
        vY = oPointCoordY(i + 1) - oPointCoordY(i)
      ' Berechnung des aktuellen Winkels
        CosAlpha = ((uX * vX + uY * vY) / (Sqr(uX * uX + uY * uY) * Sqr(vX * vX + vY * vY)))
        Alpha = ArcCos(CosAlpha)
      ' Abfrage des Winkels und festlegen, ob der Punkt bernommen werden soll
      ' MsgBox " Punkt: " & i & " / Cos(Winkel): " & CosAlpha & "(" & CosThresholdValue & ")"
        If Alpha >= AlphaThreshold _
        Then ' Lschen des Punktes
          ReducePoint(i) = 1
        End If ' Lschen des Punktes
      Next i ' Schleife ber alle "mittleren" Punkte
      
    ' berprfung des ersten Punkts, sofern es sich um einen
    ' geschlossenen Linienzug handelt
      If oLineSelectionStatus = 2 _
      Then ' geschlosssener Linienzug
      ' Aufstellen der beiden Vektoren zur Berechnung des Winkels
        i = 1
        uX = oPointCoordX(nPoint - 1) - oPointCoordX(i)
        uY = oPointCoordY(nPoint - 1) - oPointCoordY(i)
        vX = oPointCoordX(i + 1) - oPointCoordX(i)
        vY = oPointCoordY(i + 1) - oPointCoordY(i)
      ' Berechnung des aktuellen Winkels
        CosAlpha = ((uX * vX + uY * vY) / (Sqr(uX * uX + uY * uY) * Sqr(vX * vX + vY * vY)))
        Alpha = ArcCos(CosAlpha)
      ' Abfrage des Winkels und festlegen, ob der Punkt bernommen werden soll
      ' MsgBox " Punkt: " & i & " / Cos(Winkel): " & CosAlpha & "(" & CosThresholdValue & ")"
        If Alpha >= AlphaThreshold _
        Then ' Lschen des Punktes
        ' Streng genommen muss hier auch der letzte Punkt elscht werden,
        ' da es sich um einen geschlossenen Linienzug handelt ...
          ReducePoint(i) = 1
        End If ' Lschen des Punktes
      
      End If ' geschlosssener Linienzug
    
    End If ' OPTION: Reduktion von groen Winkeln
  
  
  ' -----------------------------
  ' Lschen der markierten Punkte
  ' -----------------------------
    i = 0
    For j = 1 To nPoint
      If ReducePoint(j) = 0 _
      Then ' Punkt soll bernommen werden
        i = i + 1
        oPointCoordX(i) = oPointCoordX(j)
        oPointCoordY(i) = oPointCoordY(j)
      End If ' Punkt soll bernommen werden
    Next j
    nPoint = i
  ' Anpassung der Punkteliste, wenn es sich um einen
  ' gechlossenen Linienzug handelt
    If oLineSelectionStatus = 2 _
    Then ' geschlosssener Linienzug
      i = nPoint
      j = 1
      oPointCoordX(i) = oPointCoordX(j)
      oPointCoordY(i) = oPointCoordY(j)
    End If ' geschlosssener Linienzug
  
  End Sub




'*******************************************
'*******************************************
'
' Gltten der Kontur durch Mittelwertbildung
'
'*******************************************
'*******************************************
  Private Sub ButtonSmoothenApply_Click()
  
  ' Allokation des Feldes fr die gegltteten Koordinaten
    ReDim SmoothedCoordX(nPoint) As Double
    ReDim SmoothedCoordY(nPoint) As Double
    Dim CoordX As Double
    Dim CoordY As Double
  
'  MsgBox "Glttungsweg: " & TextSmoothenValue.Value / 100 & "  Zyklen: " & TextSmoothenCycle.Value
  
  ' Schleife ber die Durchlufe der Glttung
    For i = 1 To TextSmoothenCycle.Value
    
'  MsgBox "  Zyklus: " & i
    
    ' Schleife ber alle relevanten Punkte
      For j = 2 To nPoint - 1
      
      ' Berechnung der komplett gemittelten Koordinaten
        CoordX = 0.5 * (oPointCoordX(j - 1) + oPointCoordX(j + 1))
        CoordY = 0.5 * (oPointCoordY(j - 1) + oPointCoordY(j + 1))
      ' Berechnung der vorgegebenen Glttung
        SmoothedCoordX(j) = oPointCoordX(j) + TextSmoothenValue.Value / 100 * (CoordX - oPointCoordX(j))
        SmoothedCoordY(j) = oPointCoordY(j) + TextSmoothenValue.Value / 100 * (CoordY - oPointCoordY(j))
  
  
'  MsgBox "  oPointX: " & oPointSelectionCoordX(j) & " -> CoordX: " & CoordX & "  --> SmoothedX: " & SmoothedCoordX(j)
      
      Next j ' Schleife ber alle relevanten Punkte
    
    ' Fallunterscheidung je nach Art des Linienzuges
      If oLineSelectionStatus = 2 _
      Then ' geschlosssener Linienzug
      ' Geschlossener Linienzug -> Glttung der Randpunkte
      ' Bei einem geschlossenen Linienzug ist der letzte Punkt
      ' identisch mit dem ersten Punkt der Liste!
      ' ERSTER (und LETZTER) Punkt:
        CoordX = 0.5 * (oPointCoordX(2) + oPointCoordX(nPoint - 1))
        CoordY = 0.5 * (oPointCoordY(2) + oPointCoordY(nPoint - 1))
        SmoothedCoordX(1) = oPointCoordX(1) + TextSmoothenValue.Value / 100 * (CoordX - oPointCoordX(1))
        SmoothedCoordY(1) = oPointCoordY(1) + TextSmoothenValue.Value / 100 * (CoordY - oPointCoordY(1))
        SmoothedCoordX(nPoint) = SmoothedCoordX(1)
        SmoothedCoordY(nPoint) = SmoothedCoordY(1)
      ' (VOR-)LETZTER PUNKT:
      ' ... ist bereits in der Schleife geglttet worden!
      Else ' geschlosssener Linienzug
      ' Offener Linienzug -> KEINE Glttung der Randpunkte
      ' ERSTER Punkt:
        SmoothedCoordX(1) = oPointCoordX(1)
        SmoothedCoordY(1) = oPointCoordY(1)
      ' LETZTER Punkt:
        SmoothedCoordX(nPoint) = oPointCoordX(nPoint)
        SmoothedCoordY(nPoint) = oPointCoordY(nPoint)
      End If ' geschlosssener Linienzug
    
    Next i ' Schleife ber die Durchlufe der Glttung
  
  ' Zurckspeichern der gegltteten Punkte
  ' Schleife ber alle relevanten Punkte
  j = 2
'  MsgBox "  oPoint X / Y: " & oPointCoordX(j) & " / " & oPointCoordY(j)
    For i = 1 To nPoint
      oPointCoordX(i) = SmoothedCoordX(i)
      oPointCoordY(i) = SmoothedCoordY(i)
    Next i ' Schleife ber alle relevanten Punkte
  j = 2
'  MsgBox "  oPoint X / Y: " & oPointCoordX(j) & " / " & oPointCoordY(j)
  
  End Sub




'************************************************
'************************************************
'
' Erstellen des Splines mit den aktuellen Punkten
'
'************************************************
'************************************************
  Private Sub CreateSpline_Click()
  
  ' Abfrage des Status
    If oLineSelectionStatus < 0 _
    Then ' Fehler
      MsgBox "Cannot create spline!" & vbCrLf & "Incorrect selection!"
      Exit Sub
    End If ' Fehler
  
  ' Festlegen der bentigten Variablen
    Dim oTransGeom As TransientGeometry
    Set oTransGeom = ThisApplication.TransientGeometry
    Dim oFitPoints As ObjectCollection
    Set oFitPoints = ThisApplication.TransientObjects.CreateObjectCollection
  
  ' Erstellen der Punkte und Hinzufgen zur Punkteliste
    ReDim oPoints(nPoint) As Point2d
    For i = 1 To nPoint
    ' Generieren des aktuellen Punkts
      Set oPoints(i) = oTransGeom.CreatePoint2d(oPointCoordX(i), oPointCoordY(i))
    ' Aufnahme des Punkts in die Liste
      oFitPoints.Add oPoints(i)
    Next i
  ' Erstellen des Splines
    Dim oSketch1 As PlanarSketch
    Set oSketch1 = ThisApplication.ActiveEditObject
    Dim oSpline As SketchSpline
    Set oSpline = oSketch1.SketchSplines.Add(oFitPoints)

  End Sub




'********************************************
'********************************************
'
' bernahme der Linien der aktuellen Auswahl
'
'********************************************
'********************************************
  Sub ButtonPolyLineSelectionApply_Click()
  ' Festlegen der zulssigen Koordinatenabweichugen
    CoordinateAccuracy = 0.000001
  ' Deklaration einer Ausgabe-Variable fr das Textfenster
    Dim Ausgabe As String

  ' Set a reference to the select set of the active document.
    Dim oSelectSet As SelectSet
    Set oSelectSet = ThisApplication.ActiveDocument.SelectSet
    Dim SelectionCount As Integer
    SelectionCount = oSelectSet.Count
    
  ' berprfen, ob berhaupt Elemente selektiert wurden!
    If SelectionCount = 0 _
    Then ' SelectionSet LEER!
      DialogPolylineToSpline.TextPolyLineSelectionContent.Value = "<no elements selected>"
      oLineSelectionStatus = -1
    Else ' SelectionSeit NICHT LEER!
    ' bernahme der aktuellen Auswahl
      DialogPolylineToSpline.TextPolyLineSelectionContent.Value = "<Selection accepted>"
    End If ' SelectionSet LEER!

  ' --------------------------------------------
  ' Umspeichern der Linien in eine globale Liste
  ' --------------------------------------------
    Set oLineSelection = ThisApplication.TransientObjects.CreateObjectCollection
    nLineSelection = 0
  ' Schleife ber alle ausgewhlten Objekte
    For Each obj In oSelectSet
    ' Ausgabe des aktuellen Elementnamens
    '  MsgBox "Element-Typ: " & TypeName(obj)
    ' Suche nach allen Linien
       If obj.Type = kSketchLineObject _
       Then ' Linie gefunden
         oLineSelection.Add obj
         nLineSelection = nLineSelection + 1
       End If ' Linie gefunden
    Next obj
    Ausgabe = "Aktuelle Auswahl:" & vbCrLf
    Ausgabe = Ausgabe & "Anzahl der Linien: " & nLineSelection & vbCrLf
    DialogPolylineToSpline.TextPolyLineSelectionContent.Value = Ausgabe
    
  ' Wenn keine Linie ausgewhlt wurde, dann liegt ein Fehler vor
    If nLineSelection = 0 _
    Then ' keine Linie vorhanden
    ' Ausgabe der Fehlermeldung
      Ausgabe = Ausgabe & vbCrLf & "ERROR: No lines selected!" & vbCrLf
      DialogPolylineToSpline.TextPolyLineSelectionContent.Value = Ausgabe
      oLineSelectionStatus = -2
    ' Abbruch des Programms
      Exit Sub
    End If ' keine Linie vorhanden

  ' ---------------------------------------------------------
  ' Aufbau der Kordinaten-Liste der Punkte der Linien-Auswahl
  ' ---------------------------------------------------------
  ' Allokation der Liste fr die Verweise der ausgewhlten Linien
  ' zu den Punkten in der neuen Liste
    ReDim oLineSelectionConnectedPoints(nLineSelection + 1, 2) As Integer
  ' Initialisierung der Liste mit dem ersten Start- und Endpunkt der ersten Linie
    mPointSelection = nLineSelection * 2 + 1 ' maximale Anzahl an Eintrgen
    ReDim oPointSelectionCoordX(mPointSelection) As Double
    ReDim oPointSelectionCoordY(mPointSelection) As Double
    nPointSelection = 0
    nPointSelection = nPointSelection + 1
    oPointSelectionCoordX(nPointSelection) = oLineSelection(1).StartSketchPoint.Geometry.X
    oPointSelectionCoordY(nPointSelection) = oLineSelection(1).StartSketchPoint.Geometry.Y
    nPointSelection = nPointSelection + 1
    oPointSelectionCoordX(nPointSelection) = oLineSelection(1).EndSketchPoint.Geometry.X
    oPointSelectionCoordY(nPointSelection) = oLineSelection(1).EndSketchPoint.Geometry.Y
    
  ' Schleife ber alle Linien
    For i = 1 To nLineSelection
    
    ' bernahme der aller Punkte in die Liste
    ' Festlegen der aktuellen Punkt-Stati
      StartPointFound = 0
      StartPointIndex = 0
      EndPointFound = 0
      EndPointIndex = 0
    ' Schleife ber alle bereits gefundenen Punkte
      For j = 1 To nPointSelection
      ' Abfrage des Startpunkts der aktuellen Linie
        If Abs(oPointSelectionCoordX(j) - oLineSelection(i).StartSketchPoint.Geometry.X) < CoordinateAccuracy And _
           Abs(oPointSelectionCoordY(j) - oLineSelection(i).StartSketchPoint.Geometry.Y) < CoordinateAccuracy _
        Then ' Startpunkt gefunden
          StartPointFound = StartPointFound + 1
          StartPointIndex = j
        End If ' Startpunkt gefunden
      ' Abfrage des Endpunkts der aktuellen Linie
        If Abs(oPointSelectionCoordX(j) - oLineSelection(i).EndSketchPoint.Geometry.X) < CoordinateAccuracy And _
           Abs(oPointSelectionCoordY(j) - oLineSelection(i).EndSketchPoint.Geometry.Y) < CoordinateAccuracy _
        Then ' Endpunkt gefunden
          EndPointFound = EndPointFound + 1
          EndPointIndex = j
        End If ' Endpunkt gefunden
      Next j ' Schleife ber alle bereits gefundenen Punkte
      
    ' Abfrage, ob der Startpunkt bereits in der Liste enhalten war
      If StartPointFound = 0 _
      Then ' Startpunkt noch nicht vorhanden
      ' bernahme des Startpunkts in die Punktliste
        nPointSelection = nPointSelection + 1
        oPointSelectionCoordX(nPointSelection) = oLineSelection(i).StartSketchPoint.Geometry.X
        oPointSelectionCoordY(nPointSelection) = oLineSelection(i).StartSketchPoint.Geometry.Y
        oLineSelectionConnectedPoints(i, 1) = nPointSelection
      Else
        oLineSelectionConnectedPoints(i, 1) = StartPointIndex
      End If ' Startpunkt noch nicht vorhanden
      
    ' Abfrage, ob der Endpunkt bereits in der Liste enhalten war
      If EndPointFound = 0 _
      Then ' Endpunkt noch nicht vorhanden
      ' bernahme des Endpunkts in die Punktliste
        nPointSelection = nPointSelection + 1
        oPointSelectionCoordX(nPointSelection) = oLineSelection(i).EndSketchPoint.Geometry.X
        oPointSelectionCoordY(nPointSelection) = oLineSelection(i).EndSketchPoint.Geometry.Y
        oLineSelectionConnectedPoints(i, 2) = nPointSelection
      Else
        oLineSelectionConnectedPoints(i, 2) = EndPointIndex
      End If ' Endpunkt noch nicht vorhanden
      
    Next i ' Schleife ber alle Linien

    Ausgabe = Ausgabe & "Anzahl der Punkte: " & nPointSelection & vbCrLf & vbCrLf

  ' ------------------------------------------------------
  ' Aufbau der Verbdingungs-Liste der Punkte zu dem Linien
  ' ------------------------------------------------------
  ' Allokation des Feldes fr die Verbindungsliste zwischen Punkten
  ' und Linien. Es knnen maximal zwei Linien an einem Punkt anschlieen.
  ' Wird eine dritte Linie gefunden, dann ist der Linienzug nicht ein-
  ' deutig. In diesem Falle wird dann ein Fehler ausgegeben!
  ' Die Linien werden wie folgt kodiert:
  '  + positiver Wert -> es handelt sich um den Startpunkt der Linie
  '  + negativer Wert -> es handelt sich um den Endpunkt der Linie
    ReDim oPointSelectionConnectedLinesN(mPointSelection) As Integer
    ReDim oPointSelectionConnectedLines(mPointSelection, 2) As Integer
 
  ' Schleife ber alle Punkte der Linienauswahl
    For i = 1 To nPointSelection
    ' Schleife ber alle Linien
      For j = T To nLineSelection
      ' Schleife ber Start- und Endpunkt der Linie
        For k = 1 To 2
        ' Abfrage des aktuellen Punktes
          If oLineSelectionConnectedPoints(j, k) = i _
          Then ' aktuellen Punkt gefunden
          ' berprfen, ob die maximale Verbdingungsanzahl berschritten wird
            If oPointSelectionConnectedLinesN(i) = 2 _
            Then ' mehr als 2 Linien am Punkt -> FEHLER
              Ausgabe = Ausgabe & "ERROR: No clear line selected!" & vbCrLf & vbCrLf
              DialogPolylineToSpline.TextPolyLineSelectionContent.Value = Ausgabe
              oLineSelectionStatus = -3
              Exit Sub
            End If ' mehr als 2 Linien am Punkt -> FEHLER
          ' Speichern der Verbindung zur aktuellen Linie
            oPointSelectionConnectedLinesN(i) = oPointSelectionConnectedLinesN(i) + 1
          ' Dabei wird abgefragt, um welchen Punkt der Linie es sich handelt ...
            If k = 1 _
            Then ' Startpunkt
              oPointSelectionConnectedLines(i, oPointSelectionConnectedLinesN(i)) = j
            Else ' Endpunkt
              oPointSelectionConnectedLines(i, oPointSelectionConnectedLinesN(i)) = -j
            End If ' Abfrage, um welchen Punkt es sich handelt
          End If ' aktuellen Punkt gefunden
        Next k ' Schleife ber Start- und Endpunkt der Linie
      Next j ' Schleife ber alle Linien
    Next i ' Schleife ber alle Punkte der Linienauswahl
    
  ' ------------------------------
  ' Klassifizierung des Linienzugs
  ' ------------------------------
  ' Es wird festegestellt, ob es sich um einen geschlossenen oder
  ' einen offenen Linienzug handelt
  ' Schleife ber alle Punkte der Linienauswahl
    nPointWithOneLine = 0
    iPointWithOneLine = 0
    For i = 1 To nPointSelection
    ' Abfrage der Anzahl der angeschlossenen Linien
      If oPointSelectionConnectedLinesN(i) = 1 _
      Then ' nur eine Linie angeschlossen
      ' Merken des aktuellen Punktes als Startpunkt
        iPointWithOneLine = i
      ' Zhlen der Punkte, die nur einen Nachbarn haben
        nPointWithOneLine = nPointWithOneLine + 1
      End If ' nur eine Linie angeschlossen
    Next i ' Schleife ber alle Punkte der Linienauswahl
  
  ' Fehlermeldung bei mehr als 2 Punkten mit nur einem Nachbarn
    If nPointWithOneLine > 2 _
    Then ' Linienzug nicht verbunden
      Ausgabe = Ausgabe & "ERROR: No contiguous line selected!" & vbCrLf & vbCrLf
      DialogPolylineToSpline.TextPolyLineSelectionContent.Value = Ausgabe
      oLineSelectionStatus = -4
      Exit Sub
    End If ' Linienzug nicht verbunden
  
  ' Ausgabe des Ergebnisses
    If iPointWithOneLine = 0 _
    Then ' kein Punkt mit nur einer Linie gefunden
    ' Linienzug GESCHLOSSEN
      Ausgabe = Ausgabe & "Polyline: Closed " & vbCrLf & vbCrLf
      iPointWithOneLine = 1
      oLineSelectionStatus = 2
    Else ' kein Punkt mit nur einer Linie gefunden
    ' Linienzug OFFEN
      Ausgabe = Ausgabe & "Polyline: Open " & vbCrLf & vbCrLf
      oLineSelectionStatus = 1
    End If ' kein Punkt mit nur einer Linie gefunden
    DialogPolylineToSpline.TextPolyLineSelectionContent.Value = Ausgabe

  ' Ausgabe der Linie-Punkt-Verbindungen
    Ausgabe = Ausgabe & "Line-point connections: " & vbCrLf
    For i = 1 To nLineSelection
      Ausgabe = Ausgabe & " + Line: " & i & " from point: " & oLineSelectionConnectedPoints(i, 1) & " after point: " & oLineSelectionConnectedPoints(i, 2) & vbCrLf
    Next i
    Ausgabe = Ausgabe & vbCrLf
    DialogPolylineToSpline.TextPolyLineSelectionContent.Value = Ausgabe

  ' Ausgabe der Linie-Punkt-Verbindungen
    Ausgabe = Ausgabe & "Point-line connections: " & vbCrLf
    For i = 1 To nPointSelection
      Ausgabe = Ausgabe & " + Point: " & i & " Line#1: " & oPointSelectionConnectedLines(i, 1) & " / Line #2: " & oPointSelectionConnectedLines(i, 2) & vbCrLf
    Next i
    Ausgabe = Ausgabe & vbCrLf
    DialogPolylineToSpline.TextPolyLineSelectionContent.Value = Ausgabe

  ' -----------------------------------------------------------------
  ' Aufstellen einer weiteren Punktliste in der richtigen Reihenfolge
  ' -----------------------------------------------------------------
  ' Allokation der bentigten Listen
    ReDim oPointCoordX(2 * nPointSelection) As Double
    ReDim oPointCoordY(2 * nPointSelection) As Double
    ReDim oPoint(2 * nPointSelection) As Integer
    nPoint = 1
    oPoint(nPoint) = iPointWithOneLine
    oPointCoordX(nPoint) = oPointSelectionCoordX(oPoint(nPoint))
    oPointCoordY(nPoint) = oPointSelectionCoordY(oPoint(nPoint))
  ' Index der ersten Line an dem zuletzt gefundenen Punkt
    iLine = oPointSelectionConnectedLines(oPoint(nPoint), 1)
  ' Schleife bis alle Punkte einsortiert sind
    For i = 1 To nPointSelection - 1
    ' der Nchste Punkt ist dann entweder der Start- oder der
    ' Endpunkt der Linie:
      If iLine > 0 _
      Then ' der letzte Punkt ist Startpunkt der Linie
       iPoint = oLineSelectionConnectedPoints(iLine, 2)
      Else ' der letzte Punkt ist Startpunkt der Linie
       iPoint = oLineSelectionConnectedPoints(-iLine, 1)
      End If ' der letzte Punkt ist Startpunkt der Linie
    ' benahme des gefundenen Punkts in die Liste
      nPoint = nPoint + 1
      oPoint(nPoint) = iPoint
      oPointCoordX(nPoint) = oPointSelectionCoordX(oPoint(nPoint))
      oPointCoordY(nPoint) = oPointSelectionCoordY(oPoint(nPoint))
    ' Index der ersten Line an dem zuletzt gefundenen Punkt
      If iLine = -oPointSelectionConnectedLines(oPoint(nPoint), 1) _
      Then ' die erste Linie in der Connected-Liste ist schon abgearbeitet
        iLine = oPointSelectionConnectedLines(oPoint(nPoint), 2)
      Else ' die erste Linie in der Connected-Liste ist schon abgearbeitet
        iLine = oPointSelectionConnectedLines(oPoint(nPoint), 1)
      End If ' die erste Linie in der Connected-Liste ist schon abgearbeitet
    Next i ' Schleife bis alle Punkte einsortiert sind

  ' Wenn es sich um einen geschlossenen Linienzug handelt dann kommt der erste
  ' Punkt noch einmal ans Ende
    If oLineSelectionStatus = 2 _
    Then ' geschlossener Linienzug
      nPoint = nPoint + 1
      oPoint(nPoint) = oPoint(1)
      oPointCoordX(nPoint) = oPointSelectionCoordX(oPoint(nPoint))
      oPointCoordY(nPoint) = oPointSelectionCoordY(oPoint(nPoint))
    End If ' geschlossener Linienzug
  
  ' Ausgabe der Linie-Punkt-Verbindungen
    Ausgabe = Ausgabe & "Order of points: " & vbCrLf
    For i = 1 To nPoint
      Ausgabe = Ausgabe & " -> " & i & ". Point: " & oPoint(i) & vbCrLf
    Next i
    Ausgabe = Ausgabe & vbCrLf
    DialogPolylineToSpline.TextPolyLineSelectionContent.Value = Ausgabe


  End Sub



'***********************************************
'***********************************************
'
' Beenden des PolyLine to Spline-Dialogfensters
'
'***********************************************
'***********************************************
  Private Sub ButtonCancel_Click()
  
  ' Wiederherstellen der Auswahl
    Call ReselectSelection
    
  ' Ausblenden des Dialogfensters
    DialogPolylineToSpline.Hide
  
  End Sub

Private Sub UserForm_Click()

End Sub
